<?php
require_once __DIR__.'/env.php';
env_load(__DIR__.'/../.env');

date_default_timezone_set(getenv('APP_TIMEZONE') ?: 'Asia/Tehran');

$dsn  = getenv('DB_DSN');
$user = getenv('DB_USER');
$pass = getenv('DB_PASS');

try {
  $pdo = new PDO($dsn, $user, $pass, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
} catch (Throwable $e) {
  http_response_code(500);
  echo "DB connection error";
  exit;
}
