# Virtual Number Patch Kit (PHP + PDO)

این بسته، جریان «خرید شماره مجازی» مانند اسکرین‌شات‌های شما را به پروژه‌ی PHP شما اضافه می‌کند:
- پنل‌ها → نوع اکانت → کشور/قیمت/تعداد (با چراغ وضعیت)
- محاسبه قیمت بر اساس **درصد سود** هر پنل
- پرداخت امن زرین‌پال: pending → authority → verify (ضدِ double-pay)
- PDO + Prepared Statements + `.env` برای اسرار

## راه‌اندازی سریع
1) پوشه را داخل پروژه خود کپی کنید (مثلاً در `app/`).
2) دیتابیس را با `schema.sql` ایجاد/به‌روزرسانی کنید.
3) `copy .env.example .env` و مقادیر را تنظیم کنید (توکن، DSN، merchant و ...).
4) مسیرهای وب:
   - `public/pay_request.php` برای شروع پرداخت
   - `public/pay_verify.php` برای بازگشت از زرین‌پال (Callback)
5) در هندلر ربات، روی کلیک کاربر برای کشور/قیمت، کاربر را به `pay_request.php?pid=...` هدایت کنید یا لینک پرداخت را بگیرید.

## ساختار
```
lib/
  bootstrap.php   # بارگذاری env + PDO
  env.php         # لودر ساده .env
  config.php      # ثابت‌ها از env
  telegram.php    # sendMessage ساده
  inventory.php   # قیمت‌گذاری/موجودی/کیبورد
  payments.php    # startPayment + verifyPayment (زرین‌پال)
handlers/
  buy.php         # نمونه هندلرهای callback برای منوها
public/
  pay_request.php # ایجاد رکورد pending + درخواست زرین‌پال
  pay_verify.php  # Verify امن و نهایی کردن خرید
schema.sql
examples/
  keyboard_generation.php # نمونه ساخت کیبورد لیست کشورها/قیمت‌ها
```

> نکته: این کیت مستقل از فریمورک شماست و فقط به `PDO` نیاز دارد. توابع را به سادگی در کد فعلی include کنید.
